/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.IQuickFixProcessorsRegistry;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.SimpleSourceViewerConfiguration;
import com.aptana.editor.common.contentassist.ContentAssistant;
import com.aptana.editor.common.contentassist.QuickAssistAssistant;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.XMLSourceConfiguration;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class XMLSourceViewerConfiguration
extends SimpleSourceViewerConfiguration {
    public XMLSourceViewerConfiguration(IPreferenceStore preferences, AbstractThemeableEditor editor) {
        super(preferences, editor);
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        IQuickAssistProcessor quickFixProcessor = this.getQuickAssistProcessor();
        if (quickFixProcessor != null) {
            assistant.setQuickAssistProcessor(quickFixProcessor);
        }
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
        this.applyTheme((ContentAssistant)assistant);
        return assistant;
    }

    private IQuickAssistProcessor getQuickAssistProcessor() {
        IQuickFixProcessorsRegistry registry = this.getQuickFixRegistry();
        if (registry == null) {
            return null;
        }
        AbstractThemeableEditor ate = this.getEditor();
        return registry.getQuickFixProcessor(ate == null ? "org.eclipse.core.runtime.xml" : ate.getContentType());
    }

    protected IQuickFixProcessorsRegistry getQuickFixRegistry() {
        return CommonEditorPlugin.getDefault().getQuickFixProcessorRegistry();
    }

    public ISourceViewerConfiguration getSourceViewerConfiguration() {
        return XMLSourceConfiguration.getDefault();
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new RubyRegexpAutoIndentStrategy(contentType, (SourceViewerConfiguration)this, sourceViewer, XMLPlugin.getDefault().getPreferenceStore())};
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("com.aptana.editor.xml.sourceCode", this.getEditor());
        return targets;
    }
}

